$fn = 200;   //  Sets design accuracy (50 for testing. 200 for final )

// Printer UP! Plus 2
// Material ABS
// Resolution: 0.15
// Fill: Solid
// Quality: Fine
// Needs 4 x 2mm dia, 8mm long crosspoint countersunk 'screws'
// 4 x 2mm hex nuts
// Nuts are push fit in the case holes

boxwidth = 52.7;

boxlength = 54.9;

boxheight = 3.2;

//  From base design
base_boxheight = 6.5;
base_wallthick = 1.4;
wallthick_back = 2.2;
screw_radius = 2.2 / 2;
wallthick_bottom_back = 2.7;
wallthick_side = 1.3;
back_tab_depth = 2;
back_tab_width = 4;
back_tab_thickness = .5;
wedge_height = 3;
centre_hole_depth = 2;
screw_hole_offset_x = 38.5; 
screw_hole_offset_y = 3.9; 
centre_hole_offset = 17.5;
locking_sphere_z = 4.7;
locking_sphere_y = 3.2;
locking_sphere_radius = 1;
back_screw_offset_x = 3.9 - screw_radius;
back_screw_offset_y = 4.4 - screw_radius;
chamfer = 0.5;
triangle_extension = 1;

triangle_edge_top = 7.6;

screw_hole_radius = screw_radius + .2;
stud_radius = screw_radius - .3;
back_space = 36;

label_height = .5;

triangle_height = boxheight - base_wallthick + (base_boxheight - base_wallthick -.5 );

back_wallthick_thin = 1;

pcb_length = 52.7;
pcb_width = 50.6;
pcb_thickness = 1.8;

tab_cube_width = 6;

tab_filler_cube_width = 5;


/**
 * Standard right-angled triangle
 *
 * @param number  o_len  Length of the opposite side
 * @param number  a_len  Length of the adjacent side
 * @param number  depth  How wide/deep the triangle is in the 3rd dimension
 * @param boolean center Whether to center the triangle on the origin
 * @todo a better way ?
 */
module triangle(o_len, a_len, depth, center=false)
{
    centroid = center ? [-a_len/3, -o_len/3, -depth/2] : [0, 0, 0];
    translate(centroid) linear_extrude(height=depth)
    {
        polygon(points=[[0,0],[a_len,0],[0,o_len]], paths=[[0,1,2]]);
    }
}

// MAIN BOX
difference() 
{
    cube([boxlength, boxwidth, boxheight]);
    
    // label
    translate([36.7, 2.8, boxheight - label_height])
    cube([16.5, boxwidth - (2.8 * 2), label_height]);
    
   // Screw holes
    translate([ screw_hole_offset_x + screw_radius + back_wallthick_thin, screw_hole_offset_y + screw_radius + back_wallthick_thin, 0])
    rotate([0,0,0]) cylinder(r=screw_hole_radius, h=boxheight);
    
    translate([ screw_hole_offset_x + screw_radius + back_wallthick_thin , boxwidth - screw_hole_offset_y  - screw_radius - back_wallthick_thin, 0])
    rotate([0,0,0]) cylinder(r=screw_hole_radius, h=boxheight);
    
    // chamfer for screw head
     translate([ screw_hole_offset_x + screw_radius + back_wallthick_thin, screw_hole_offset_y  + screw_radius + back_wallthick_thin, boxheight - 1.1 ])
    rotate([0,0,180]) cylinder( r1=0, r2=screw_hole_radius + 1 , h = back_wallthick_thin - label_height );
    
     translate([ screw_hole_offset_x + screw_radius + back_wallthick_thin, boxwidth - screw_hole_offset_y  - screw_radius - back_wallthick_thin, boxheight - 1.1])
    rotate([0,0,180]) cylinder( r1=0, r2=screw_hole_radius + 1 , h =  back_wallthick_thin - label_height);
    
    // Test holes for checking stud position
    // centre studs
    //translate([ screw_hole_offset_x +  back_wallthick_thin + screw_radius, centre_hole_offset + screw_radius + back_wallthick_thin, 0])
    //cylinder(r=screw_hole_radius, h=boxheight);
    
    //translate([ screw_hole_offset_x +  back_wallthick_thin + screw_radius, boxwidth  - centre_hole_offset - screw_radius - back_wallthick_thin ,  ])
    //cylinder(r=screw_hole_radius, h=boxheight);

    chamfer();
    // label_height) / 1.5);
   
    // 
    
 
    // pcb space
    
    translate([ back_wallthick_thin - .1, back_wallthick_thin - .1, 0 ])
   
    cube([  pcb_length + .2, pcb_width + .2, pcb_thickness ]);
    
    // back space for caps
    
    translate([ 5, 5, 0 ])
   
    cube([ back_space - 5, pcb_width - 8 , boxheight - back_wallthick_thin  ]);
    
    back_screws();
    
}

// centre studs
// They break off
    
//translate([ 39.6 + stud_radius , centre_hole_offset + screw_radius, boxheight - (pcb_thickness * 2) - centre_hole_depth  + .5])
//cylinder(r=stud_radius , h=centre_hole_depth + pcb_thickness );
     
//translate([ 39.6 + stud_radius , boxwidth  - centre_hole_offset - screw_radius,  boxheight - (pcb_thickness * 2) - centre_hole_depth + .5])
//cylinder(r=stud_radius , h=centre_hole_depth + pcb_thickness );

// test cylinder
    //   translate([ 39.6 + screw_radius, 4.9 + screw_radius, boxheight - 1.1 ])
    //rotate([0,0,180]) cylinder( r1=0, r2=screw_radius + 1.5, h =  back_wallthick_thin - label_height);
    
/// Back triangular blocks

difference()
{
//LH
    translate([ 0 , 0 , boxheight ])

    rotate([180,0, 90]) triangle( triangle_edge_top + .2 , triangle_edge_top + .2 , boxheight - triangle_extension );
    
    // screw holes
    back_screws();
    chamfer();
    
}
// - superceded.  Now use screw
//translate([ wallthick_bottom_back + .1 ,wallthick_side + .3, 1 ])
//rotate([180,0, 90]) triangle( triangle_edge_top - 4, triangle_edge_top - 4, 5  );

    // locking sphere - superceded.  Now use screw
    
//    translate([ wallthick_back + .7, locking_sphere_y , - (base_boxheight - locking_sphere_z) ])
//    sphere( locking_sphere_radius);
    
    


difference()
{
//RH
    translate([ 0 ,  boxwidth  , boxheight ])
    rotate([180,0, 0]) triangle( triangle_edge_top + .2, triangle_edge_top + .2, boxheight - triangle_extension  );
   
    back_screws();
    chamfer();
}
// - superceded.  Now use screw
//translate([ wallthick_bottom_back , boxwidth - wallthick_side - .4,  1 ])
//rotate([180,0, 0]) triangle( triangle_edge_top - 4, triangle_edge_top - 4, 5 );

  // locking sphere - superceded.  Now use screw
//translate([ wallthick_back + .7, boxwidth - locking_sphere_y , - (base_boxheight - locking_sphere_z)  ])
//sphere( locking_sphere_radius);


module back_screws()
{
    // Called both for main box and triangles
    //LH
     // screw hole
    translate([ back_screw_offset_x + chamfer, back_screw_offset_y, 0 ])
    cylinder( r=screw_radius, h=boxheight );

    // chamfer for LH screw head
    translate([ back_screw_offset_x + chamfer, back_screw_offset_y, boxheight - 1.1 ])
    rotate([0,0,180]) cylinder( r1=0, r2=screw_hole_radius + 1 , h = back_wallthick_thin  );


    //RH
     // screw hole
    translate([ back_screw_offset_x + chamfer, boxwidth -back_screw_offset_y, 0 ])
    cylinder( r=screw_radius, h=boxheight );


    // chamfer for RH screw head
    translate([ back_screw_offset_x + chamfer, boxwidth - back_screw_offset_y, boxheight - 1.1])
    rotate([0,0,180]) cylinder( r1=0, r2=screw_hole_radius + 1 , h =  back_wallthick_thin);
    
}

// copies base chamfer, so is offset to -boxheight_base.
module chamfer()
{
       // Side chamfer
    
    //LH
    translate([ 0, 0, - base_boxheight ])
    rotate([90,0,90]) triangle( base_boxheight + boxheight, chamfer, boxlength );
    
    //RH
    translate([ boxlength, boxwidth, - base_boxheight ])
    rotate([270,180,90]) triangle( base_boxheight + boxheight, chamfer, boxlength );
}
    

    

