$fn = 200;   //  Sets design accuracy (50 for testing)

// Printer UP! Plus 2
// Material ABS
// Resolution: 0.15
// Fill: Solid
// Quality: Fine
// Needs 4 x 2mm dia, 8mm long crosspoint countersunk 'screws'
// 4 x 2mm hex nuts
// Nuts are push fit in the case holes


wallthick_side = 1.3;

wallthick_back = 2.2;


wallthick_bottom_back = 2.7;
wallthick_side_front = 1.7;
wallthick_bottom_front = 3.3;
wallthick_side_back = 2;

boxwidth = 52.6;

boxlength = 54.9;
chamfer = .5;

boxheight = 6.5;

screw_hole_offset_x = 38.5;  // for top
screw_hole_offset_y = 3.9;  // for top
centre_hole_offset = 17.5; // for top
centre_hole_depth = 5.6;

stud_height = 1.5;

locking_sphere_z = 4.7;
locking_sphere_y = 3.2;
locking_sphere_radius = 1;

screw_radius = 2.2 / 2;
nut_radius = 2.3;
nut_height = 1.6;
nut_offset = nut_height + 3 ;

pcb_pin_diameter = 2;
pcb_pin_radius = pcb_pin_diameter / 2;

// from top design
boxheight_top = 3.2; 
triangle_extension = 1;
back_hole_radius = .9;
back_hole_offset = 1.4;
back_hole_depth = 3;
back_screw_offset_x = 3.9 - screw_radius;
back_screw_offset_y = 4.4 - screw_radius;
back_wallthick_thin = 1;
triangle_edge_top = 7.7;

back_tab_depth = 2;
back_tab_thickness = .5;
back_tab_width = 4;

triangle_edge_bottom = 9;

triangle_edge_top_reduction =   1;

/**
 * Standard right-angled triangle
 *
 * @param number  o_len  Length of the opposite side
 * @param number  a_len  Length of the adjacent side
 * @param number  depth  How wide/deep the triangle is in the 3rd dimension
 * @param boolean center Whether to center the triangle on the origin
 * @todo a better way ?
 */
module triangle(o_len, a_len, depth, center=false)
{
    centroid = center ? [-a_len/3, -o_len/3, -depth/2] : [0, 0, 0];
    translate(centroid) linear_extrude(height=depth)
    {
        polygon(points=[[0,0],[a_len,0],[0,o_len]], paths=[[0,1,2]]);
    }
}

// MAIN BOX
difference() 
{
    cube([boxlength, boxwidth, boxheight]);
    
    // Back cutout
    translate([wallthick_back, wallthick_side_back, wallthick_bottom_back])
    cube([35.6, boxwidth - (2*wallthick_side_back), boxheight - wallthick_bottom_back]);
    
    // front cutout
    translate([ 42.7, wallthick_side, wallthick_bottom_front])
    cube([ 20, boxwidth - (2*wallthick_side), boxheight - wallthick_bottom_front]);
    
    // front slot
    translate([ 42.7, 23.4 , wallthick_side_front])
    cube([ boxwidth - wallthick_side_front, 6.1, boxheight]);
    
    // Screw holes
    translate([ screw_hole_offset_x + back_wallthick_thin  + screw_radius, screw_hole_offset_y + back_wallthick_thin + screw_radius, 0])
    rotate([0,0,0]) cylinder(r=screw_radius, h=boxheight);
    
    translate([ screw_hole_offset_x +  back_wallthick_thin + screw_radius, boxwidth - screw_hole_offset_y - back_wallthick_thin -  screw_radius, 0])
    rotate([0,0,0]) cylinder(r=screw_radius, h=boxheight);
    
    // nut holes
    translate([ screw_hole_offset_x +  back_wallthick_thin + screw_radius, screw_hole_offset_y + back_wallthick_thin  + screw_radius, 0])
    rotate([0,0,0]) cylinder(r=nut_radius - .1, h=nut_offset);
    
    translate([ screw_hole_offset_x +  back_wallthick_thin + screw_radius, boxwidth - screw_hole_offset_y - back_wallthick_thin -  screw_radius , 0])
    rotate([0,0,0]) cylinder(r=nut_radius - .1, h=nut_offset);
    
    // grab strip
    translate([ 1.5, boxwidth - 10 , 0 ])
    rotate([90,0,0]) triangle( 2, 2,  boxwidth - 20 );
    
    chamfer();
    
    back_screws();
    
    // Now studs (see later)
    
    // centre holes
    // Tabs break off on lid
    //translate([ screw_hole_offset +  wallthick_back_thin + screw_radius, centre_hole_offset + screw_radius, boxheight - centre_hole_depth - 1 ])
    //cylinder(r=screw_radius, h=centre_hole_depth + 1);
    
    //translate([ screw_hole_offset +  wallthick_back_thin + screw_radius, boxwidth  - centre_hole_offset - screw_radius, boxheight- centre_hole_depth - 1 ])
    //cylinder(r=screw_radius, h=centre_hole_depth + 1);
    
    // locking sphere - superceded by screw/nut
    
    // translate([ wallthick_back, locking_sphere_y , locking_sphere_z ])
    // sphere( locking_sphere_radius);
    
    // translate([ wallthick_back, boxwidth - locking_sphere_y , locking_sphere_z ])
    //sphere( locking_sphere_radius);
}

// centre studs
 translate([ screw_hole_offset_x +  back_wallthick_thin + screw_radius, centre_hole_offset + screw_radius + back_wallthick_thin, boxheight])
    cylinder(r=screw_radius - .1, h=stud_height);
    
    translate([ screw_hole_offset_x +  back_wallthick_thin + screw_radius, boxwidth  - centre_hole_offset - screw_radius - back_wallthick_thin , boxheight ])
    cylinder(r=screw_radius - .1, h=stud_height);

//////////////////////////////////////////////    
    /// Back base triangular blocks - bottom part
difference()
{
    //LH
    translate([ 0 , back_wallthick_thin , boxheight  ])
    rotate([180,0, 90]) triangle( triangle_edge_bottom , triangle_edge_bottom  , boxheight );
    
    /// remove top wall overlap 
    // y direction
   // translate([  0 , back_wallthick_thin, boxheight ])
   // cube([ back_wallthick_thin, triangle_edge_bottom, triangle_extension ]); 
    
    // x direction
    //translate([ back_wallthick_thin, 0, boxheight ])
    //cube([ triangle_edge_bottom, back_wallthick_thin, 0 ]); 
    
    
    chamfer();
    back_screws();
    // repeat on main box
    // screw hole
    //translate([ back_screw_offset_x, back_screw_offset_y, 0 ])
    //cylinder( r=screw_radius, h=boxheight );

    // nut hole
    //translate([ back_screw_offset_x, back_screw_offset_y, 0])
    //cylinder( r=nut_radius - .1, h=nut_offset );
}

difference()
{
    //RH
    translate([ 0 , boxwidth-  back_wallthick_thin, 0 ])
    rotate([180,180, 90]) triangle( triangle_edge_bottom, triangle_edge_bottom, boxheight  ); 
     
    /// remove top wall overlap
    // y direction
    //translate([ 0, boxwidth - triangle_edge_bottom, boxheight ])
    //cube([ back_wallthick_thin, triangle_edge_bottom, triangle_extension ]); 
    
    // x direction
    //translate([ 0, boxwidth - back_wallthick_thin, boxheight ])
    //cube([ triangle_edge_bottom, back_wallthick_thin, triangle_extension ]); 
    
    chamfer();
    back_screws();
    // Side chamfer test

   // translate([ boxlength, boxwidth + 5, 0 ])
   //  rotate([270,180,90]) triangle( boxheight, chamfer, boxlength );
}  



////////////////////////////////////////////////////////
/// Latching part of triangle

difference()
{
    //LH
    translate([ back_wallthick_thin , back_wallthick_thin , boxheight + triangle_extension])

    rotate([180,0, 90]) triangle( triangle_edge_top - triangle_edge_top_reduction - back_wallthick_thin , triangle_edge_top - triangle_edge_top_reduction - back_wallthick_thin , triangle_extension );
    
    // screw holes etc
    back_screws();
    chamfer();
}

difference()
{
    
      //RH
    translate([ back_wallthick_thin , boxwidth - back_wallthick_thin, boxheight ])
    rotate([180,180, 90]) triangle( triangle_edge_top - triangle_edge_top_reduction - back_wallthick_thin, triangle_edge_top - triangle_edge_top_reduction - back_wallthick_thin, triangle_extension  ); 
    
    // screw holes etc
    back_screws();
    chamfer();
     
}


////////////////////////////////////////////////
module back_screws()
{
    // Called both for main box and triangles
    //LH
     // screw hole
    translate([ back_screw_offset_x + chamfer, back_screw_offset_y, 0 ])
    cylinder( r=screw_radius, h=boxheight + triangle_extension);

    // nut hole
    translate([ back_screw_offset_x + chamfer , back_screw_offset_y, 0])
    cylinder( r=nut_radius - .1, h=nut_offset );

    //RH
     // screw hole
    translate([ back_screw_offset_x + chamfer, boxwidth -back_screw_offset_y, 0 ])
    cylinder( r=screw_radius, h=boxheight + triangle_extension);

    // nut hole
    translate([ back_screw_offset_x + chamfer, boxwidth -back_screw_offset_y, 0])
    cylinder( r=nut_radius - .1, h=nut_offset );
    
}

module chamfer()
{
       // Side chamfer
    
    //LH
    translate([ 0, 0, 0 ])
    rotate([90,0,90]) triangle( boxheight + boxheight_top, chamfer, boxlength );
    
    //RH
    translate([ boxlength, boxwidth, 0 ])
    rotate([270,180,90]) triangle( boxheight + boxheight_top, chamfer, boxlength );
}
    

 